<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'Contact Us',
            'title' => 'Get In Touch',
            'subtitle' => 'Have questions or ready to schedule a pickup?',
            'form_title' => 'Schedule a Pickup',
            'form_labels' => [
                'name' => 'Full Name',
                'phone' => 'Phone Number',
                'email' => 'Email Address',
                'service' => 'Service Type',
                'service_placeholder' => 'Select a service',
                'date' => 'Preferred Pickup Date',
                'notes' => 'Additional Notes',
                'notes_placeholder' => 'Any special instructions...',
                'submit' => 'Schedule Pickup',
            ],
            'info_labels' => [
                'phone' => 'Phone',
                'email' => 'Email',
                'address' => 'Address',
                'hours' => 'Business Hours',
                'follow_us' => 'Follow Us',
            ],
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section id="contact" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-16">
            {{-- Contact Info --}}
            <div>
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                <h2 class="section-title text-left">{{ $section['title'] }}</h2>
                <p class="text-gray-600 dark:text-gray-400 mb-8">{{ $section['subtitle'] }}</p>

                <div class="space-y-6">
                    {{-- Phone --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:phone" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                {{ $section['info_labels']['phone'] }}</h3>
                            <a href="tel:{{ $company['phone'] }}"
                                class="text-gray-600 dark:text-gray-400 hover:text-primary-600 transition-colors">{{ $company['phone'] }}</a>
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:envelope" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                {{ $section['info_labels']['email'] }}</h3>
                            <a href="mailto:{{ $company['email'] }}"
                                class="text-gray-600 dark:text-gray-400 hover:text-primary-600 transition-colors">{{ $company['email'] }}</a>
                        </div>
                    </div>

                    {{-- Address --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:map-pin" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                {{ $section['info_labels']['address'] }}</h3>
                            <p class="text-gray-600 dark:text-gray-400">{{ $company['address'] }}</p>
                        </div>
                    </div>

                    {{-- Hours --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:clock" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                {{ $section['info_labels']['hours'] }}</h3>
                            <p class="text-gray-600 dark:text-gray-400">{{ $company['hours'] }}</p>
                        </div>
                    </div>
                </div>

                {{-- Social Links --}}
                @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                    <div class="mt-8">
                        <p class="font-semibold text-gray-900 dark:text-white mb-4">
                            {{ $section['info_labels']['follow_us'] }}</p>
                        <div class="flex gap-4">
                            @foreach ($social as $key => $link)
                                @if ($key !== 'show_icon' && is_array($link))
                                    <a href="{{ $link['url'] }}"
                                        class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center hover:bg-primary-600 hover:text-white transition-all duration-300">
                                        <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            {{-- Contact Form --}}
            <livewire:laundry::components.contact-form :formTitle="$section['form_title']" :formLabels="$section['form_labels']" />
        </div>
    </div>
</section>
